<?php
ini_set('default_charset', 'UTF-8');

// HERE ARE THE SETTINGS FOR CONFIGURATION
$lang = "ru";
$starting_dir = ".";
$open_in_new_window = 1;
$max_space = 25600;
$dir_levels = 3;
$show_top = 1;
$show_index = 0;
$charset = "utf-8";
$hidden_dirs = array();
$hidden_files = array(".ftpquota", "index.php");
$password = "";
$basedir = "";

// TRANSLATIONS
$_TRANSLATIONS = array();
$_TRANSLATIONS["en"] = array(
	"file_name" => "File name",
	"size" => "Size",
	"last_changed" => "Last changed",
	"total_used_space" => "Total used space",
	"free_space" => "Free space",
	"password" => "Password",
	"upload" => "Upload",
	"failed_upload" => "Failed to upload the file!",
	"failed_move" => "Failed to move the file into the right directory!",
	"wrong_password" => "Wrong password",
	"make_directory" => "New dir",
	"new_dir_failed" => "Failed to create directory",
	"chmod_dir_failed" => "Failed to change directory rights"
);
$_TRANSLATIONS["ru"] = array(
	"file_name" => "Название файла",
	"size" => "Размер",
	"last_changed" => "Последнее изменение",
	"total_used_space" => "Общий размер",
	"free_space" => "Свободное место",
	"password" => "Пароль",
	"upload" => "Загрузить",
	"failed_upload" => "Не удалось загрузить файл!",
	"failed_move" => "Не удалось переместить файл в указанную директорию!",
	"wrong_password" => "Неверный пароль",
	"make_directory" => "Новый каталог",
	"new_dir_failed" => "Не удалось создать новый каталог",
	"chmod_dir_failed" => "Не удалось изменить права каталога"
);
function css() {
?>
<style type="text/css">
BODY {
	background-color: rgb(240, 240, 225);
}
A {
	color: #000000;
	text-decoration: none;
}
A:hover {
	text-decoration: underline;
}
#top {
	width:674px;
	height:110px;
	margin:1px;
	clip: rect(20px, 97px, 3px, 33px);
	overflow:hidden;
}
#top div{
	position:absolute;
	overflow:hidden;
	white-space:nowrap;
	height:107px;
	width:674px;
}
#top div.a0 {
	font-size: 18px;
	font-weight:bold;
	font-family: Verdana,Tahoma,Arial,sans-serif;
	color:rgb(255, 255, 255);
	height:auto;
	
	text-align:center;
	top:50px;	
}
#top div.a1 {
	font-size: 70px;
	color:rgb(255, 153, 0);
	line-height:30px;
	text-indent: -100px;
}
#top div.a2 {
	font-size: 50px;
	color:rgb(255, 153, 0);
	line-height:95px;
	text-indent: -80px;
}
#top div.a3 {
	font-size: 30px;
	color: rgb(255, 153, 0);
	line-height:155px;
	text-indent: -160px;
}
#top div.a4 {
	font-size: 24px;
	color:rgb(255, 153, 0);
	line-height:205px;
	text-indent: -8px;
}
#top div.a5 {
	font-size:34px;
	position:absolute;
	top:0px;
	left:0px;
}
#frame {
	width:680px;
	border: 2px solid rgb(160, 160, 160);
	text-align:left;
	position: relative;
	margin: 0 auto;
	background-color: rgb(255, 102, 0);
}
#error {
	width:300px;
	background-color:#FFE4E1;
	font-family:Verdana;
	font-size:10px;
	color:#000000;
	padding:7px;
	position: relative;
	margin: 10px auto;
	text-align:center;
	border: 1px dotted #CDD2D6;
}
input {
	font-family:Verdana;
	font-size:10px;
	border: 1px solid #CDD2D6;
}
table.table {
	width: 680px; 
	font-family: Verdana; 
	font-size: 11px;
	margin:0px;
}
table.table tr.row.one {
	background-color:#fcfdfe;
}
table.table tr.row.two {
	background-color:#f4f4f4;
}
table.table tr.row td.icon {
	width:25px;
	text-align: center;
}
table.table tr.row td.name {
	
}
table.table tr.row td.size {
	width: 100px; 
	text-align: right;
}
table.table tr.row td.changed {
	width: 150px;
	text-align: center;
}
table.table tr.row td.long {
}
#upload {
	color:#000000;
	font-family:Verdana;
	font-size:10px;
	width:680px;
	position: relative;
	margin: 0 auto;
	text-align:center;
}
#upload input.text{
	width:100px;
}
#upload td.password {
	text-align:left;
}
#upload td.file {
	text-align:right;
}
#info {
	background: #9AFF01;
	font: bold 12px Verdana ;
	height: 20px;
	padding: 5px 10px 0px 10px;
	text-align:center;
}
#info a {
	color: #FF6600;
}
</style>
<?php
}
// IMAGE CODES IN BASE64
$icons = array();
$icons["unknown"] = "R0lGODlhEAAQALMAAAAAAAAA/wCEAISEhMbGxv8AAP//AP////////////////////////////////+A/yH5BAEAAA8ALAAAAAAQABAAAAQ58L1Bq5V4ns03GZnWccQBYsPIASyAqh3hSinszaItv/ax0z0frqYbBn85GJKoNPaWhKh0imxZr64IADs=";
$icons["directory"] = "R0lGODlhDwANAMIGAP//mczMZgAAAP/MmZmZAP//zP///////yH5BAEAAAcALAAAAAAPAA0AAAM9eEfMohCSUwoA5MUVug9Ns1RkWQGBQFhX6w7p6rYDUMfsbNv4XP8oVY62gwmJwIFxlSwqY5/o5yGoWq/XBAA7";
$icons["arrow_down"] = "R0lGODlhBwAGAIABAHh5f////yH+FUNyZWF0ZWQgd2l0aCBUaGUgR0lNUAAh+QQBCgABACwAAAAABwAGAAACCowfoMucbhZKpwAAOw==";
$icons["arrow_up"] = "R0lGODlhBwAGAIABAHh5f////yH+FUNyZWF0ZWQgd2l0aCBUaGUgR0lNUAAh+QQBCgABACwAAAAABwAGAAACCoxhCavLDiNLqQAAOw==";
$icons["mov"] = "R0lGODlhEAAQAKL/AMDAwAD/AACAAP8AAP///8DAwICAgAAAACH5BAEAAAAALAAAAAAQABAAAANSCArW7isaQispJqppaSGZ1FFHeYijdwgLlxarEAh0LVANLJRBf/Q7geEAO5l+wB8MppD1nrsV8QQQDHwBKaHEBBy/le4mpUK9qJuCes1Ge7/wBAA7";
$icons["avi"] = "R0lGODlhEAAQALP/AMDAwAAAgAD//wCAgP8AAP///8DAwICAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAAALAAAAAAQABAAAARYEEhwqrUzn8J7MUcmbR5nFKFWckiLqKuJDBMZG/MgDHw/cBXcoCUoIorDwQGBe7mOyCMOJ9EVr8MZ8wUYEIwCRABRaFEBz9aYLIPduKNYu2ao2+9wdHofAQA7";
$icons["wmv"] = $icons["avi"];
$icons["mpeg"] = $icons["avi"];
$icons["mpeg"] = $icons["avi"];
$icons["wav"] = "R0lGODlhEAAQALP/AMDAwAAAgAD//wCAgP8AAP///8DAwICAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAAALAAAAAAQABAAAARYEEhwqrUzn8J7MUcmbR5nFKFWckiLqKuJDBMZG/MgDHw/cBXcoCUoIorDwQGBe7mOyCMOJ9EVr8MZ8wUYEIwCRABRaFEBz9aYLIPduKNYu2ao2+9wdHofAQA7";
$icons["mp3"] = "R0lGODlhEAAQAJEAAMDAwP///8bGxgAAACH5BAEAAAAALAAAAAAQABAAQAI5xI45wDwB4XtQLBNzEPFSnVkOWE3NJx2RiJGrtwnyTMPu0bSghYxu6esEPixKYqgq/oA6V1EBxRUAADs=";
$icons["gif"] = "R0lGODlhEAAQALMAAAAAAL8AAAC/AL+/AMDAwICAgP8AAAD/AAD//////wAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAgALAAAAAAQABAAAARcsMhJkb0l6a1JuVbGbUTyIUYgjgngAkYqDgQ9DEBCxAEiEi8ALsELaXCHJK5o1AGSh0EBEABgjgABwQMEXp0JgcDl/A6x5WZtPfQ2g6+0j8Vx+7b4/NZqgftdFxEAOw==";
$icons["bmp"] = "R0lGODlhEAAQALMAAAAAAL8AAAC/AL+/AAAAv78AvwC/v8DAwICAgP8AAAD/AP//AAAA//8A/wD//////yH5BAEAAAoALAAAAAAQABAAAARaUEmJAKhgzkwt3gpSUQ9gHNx1PWMSmA6hDGWGHAzgwsRwjBKCgbEzIAaLAWciLCKVmpBoSgVSDo/sYfuzXrtTSzSE1XaXk5t5671mH+w2ef1Du80iu8TC52siADs=";
$icons["png"] = "R0lGODlhEAAQALP/AMDAwAD/AACAAICAAP8AAIAAAP///8DAwICAgAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAAALAAAAAAQABAAAARcEMlJgb3I6K0PulbGbYfxAUQhjkbiJkQqDgc9DIlxxAUgHq8EzsALaXCBJK5o1CWSgQEiUUhgjgnBwQMEXp0GgcDl/A6x5WZtPfQ2g6+0j8Vx+7b4/NZqgftdFxEAOw==";
$icons["jpeg"] = "R0lGODlhEAAQALMAAAAAAL8AAAC/AL+/AAAAv78AvwC/v8DAwICAgP8AAAD/AP//AAAA//8A/wD//////yH5BAEAAAoALAAAAAAQABAAAARaEMlJlb3o6a0PulbGbcfzKQwhjg/gAkwqDgdNA88RE4p4vIABbhfSCBNIIbGYAyATAwSAAMAYAYGD5/ezNhOBgKvpPV7JzJpaiO5pgK/2iiXX2u/aqgXOd10iADs=";
$icons["jpg"] = $icons["jpeg"];
$icons["exe"] = "R0lGODlhEAAOAMIAAP///5mZmWZmZgAAAMzMzAAAzAAAmf///yH5BAEAAAcALAAAAAAQAA4AAAM8GKK83oLISWcYgZTN+xbDUhjjCAzneWWC87whAcx0Pa+yrYORrq8Bnw2UEdYuPeOMl1OuXo3oYEqtWqcJADs=";
$icons["chm"] = "R0lGODlhEAAQAKIAAAAAhP//AISEAMDAwP///8bGxoSEhAAAACH5BAEAAAMALAAAAAAQABAAQANQOLoq7ssQYqoUIZQTrTlZURUZJ1EWAZZMi2WwOJxTDayaOXkT19I1guBAFLRcMI3x+Ao4YLrJpviBzoKUQ3OjANYEngh2MiyKxzjfjMhuHxMAOw==";
$icons["css"] = "R0lGODlhDQAQAMQAAAAAAP///4SGhMbHxroPAKENAIgMAM0cDdEwItREONpYTOOFfOyspvfY1eeXkfLDwPvq6v///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAABEALAAAAAANABAAAAVVoCCOZGQKQaqmg3Cu6xC4KJwCOFDbrG5DDEhg4IMRHAUIcddINBABAmMZYCQOi1SjMNQlpCvFoytgHA4MVZqcelwDD0NvF2i05zzVcsDv+4k5gYIAIQA7";
$icons["doc"] = "R0lGODlhEAAQAMIBAAAAAP///wAA/8zMzJmZmWZmZv///////yH5BAEAAAcALAAAAAAQABAAAANUeErF3kXJU4K9loB5CMbVJlWfBZynAKjsug7B4AoBW7uw7Ab7DmuH1Y2mquQ2reRg4JEFk7uL09YiLI9PAI/lkSKFraU1AFyUME5F4cpmizqouDwBADs=";
$icons["gz"] = "R0lGODlhEAAQAMQAAJzO/2OczgBjnGPO/wCczgAxMTHOzsDAwM7OMf//nP//zv//986cAP/OMf/OY//OnP8AAP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAcALAAAAAAQABAAQAVr4CGOUmkWI6Qkj9O8DSMdEjBDUbSs7TvXsxHJVEKJICxHgWgSAFCQ3crh8tFsBwhz6zQKRRKBhBAOHyEQmoBAMBgGASN6TkdfbzrFFPbDRqdVDQh9N0kwMTJ3X2psbnBeiyQEkUJiYmRiByEAOw==";
$icons["rar"] = "R0lGODlhEAAQAIQBAAAAAP///wAAmQAAZszMzJkAAGYAZpkAmf8A/wCZZmYAADMzMwD/ADOZzDMAmZmZmQAzmTP/AACZ/wAzzP//AJmZM2ZmADOZmQBm////M2ZmZgCZzACZMwBmZgBmAP///yH5BAEAAB8ALAAAAAAQABAAAAV8YKGI5GiSH6ESxmO8MFwQQX1QSK7rylMHBsJhSCQWfgFAZcHUMJ8FwUAgAFivWECK8CAMLlKBYxoe0GqdTEPS2LDXDcc5cCFAJhPMHaIXIAEWZVSDA1mGWFsqAxVTjWVyPxwUDJQRDJaWAz41HgQJn6CgDn8WY4KNh6kfIQA7";
$icons["zip"] = "R0lGODlhEAAQAMQAAJzO/2OczgBjnGPO/wCczgAxMTHOzsDAwM7OMf//nP//zv//986cAP/OMf/OY//OnP8AAP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAcALAAAAAAQABAAQAVr4CGOUmkWI6Qkj9O8DSMdEjBDUbSs7TvXsxHJVEKJICxHgWgSAFCQ3crh8tFsBwhz6zQKRRKBhBAOHyEQmoBAMBgGASN6TkdfbzrFFPbDRqdVDQh9N0kwMTJ3X2psbnBeiyQEkUJiYmRiByEAOw==";
$icons["7z"] = $icons["zip"];
$icons["php"] = "R0lGODlhDgAQAOMAAP///wAAAMzMzJmZmWZmZpnMmWaZZjOZM8zMmQBmAMz//5nMzDOZZmbMmWaZM////yH5BAEAAA8ALAAAAAAOABAAAARUcJAh6RwvvwG67wKWEd8nAETGlV3gBhtrwiRbgPD6HUsCCLmPQWAAHArAB6lgOHp8yYGBcfM0TlEEw7HwIHAxgKIp9v1osu85LFsTBPC4PPmq22ERADs=";
$icons["asp"] = "R0lGODlhEAAQAKIAAAAA/wAAhACEhMDAwP///8bGxoSEhAAAACH5BAEAAAMALAAAAAAQABAAQANKOLrcewUeAokI9JG4oTlgA35RUQDFJ6bg4SgSxxGGCpdxERjRO4wf16vl05SCQoak06n1brFJgUBNLpeGy/NHyp22jwPJZCuGGAkAOw==";
$icons["htm"] = "R0lGODlhEAAQALMAAAAA/wAAhDFj/zFjnDGc/zHO/wCEhDH//8DAwDGcAP////f398bGxoSEhAAAAAAAACH5BAEAAAgALAAAAAAQABAAQARXsMlJJbqoqb1U+FvoZGFnGEK4jdoyvDDcsWqpLIzSXBpnHIVEQEVzxWIzUmd5ayZ7tRBjx1MxZ44sKWRQHAhD0XYjICQA4dX26rzR2uzFO+4cZe/4/CgCADs=";
$icons["html"] = $icons["htm"];
$icons["js"] = "R0lGODlhEAAQAOMAAP///wAAAMzMzJmZmWZmZv//AJmZAGZmAP///////////////////////////////yH5BAEAAAgALAAAAAAQABAAAARbcJAh6aw1DMB5nZ0QEB0wFAAqcuLGkYdhtAHQepyqrSJpAoZYYFizaV4oXanXOQVnRaMLmTKyjh5KIGZlAki0FO+4KYySK6NvIBAMAu3ojUMkLkftvH5f7/uHEQA7";
$icons["jsp"] = "R0lGODlhEAAQAOMAAP///wAAAMzMzJmZmWZmZv//AJmZAGZmAP///////////////////////////////yH5BAEAAAgALAAAAAAQABAAAARbcJAh6aw1DMB5nZ0QEB0wFAAqcuLGkYdhtAHQepyqrSJpAoZYYFizaV4oXanXOQVnRaMLmTKyjh5KIGZlAki0FO+4KYySK6NvIBAMAu3ojUMkLkftvH5f7/uHEQA7";
$icons["pdf"] = "R0lGODlhEAAQALMAAP///+/v7wAAAN4AAMbGxgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP+A/yH5BAEAAA8ALAAAAAAQABAAQARF8D1Bq5V4hh3G4JswWSQoSkLnfZsXiGQpECfKfSxXp227vhiBC2QKEnU7AECgZC5fFePtuJvmQlIfsdr7dXa4IxYViz0iADs=";
$icons["ppt"] = "R0lGODlhEAAQAIQAAP////8AAAAAAMzMzGZmAJmZAGZmZpmZmWaZAMzMmZmZzMyZzJnMmZmZZplmAGZmmf///////////////////////////////////////////////////////////////yH5BAEAABAALAAAAAAQABAAAAVzICQeBmmWhqhCBuC+bikGBR0gNuIeQErAsIBLQBQIA4SAAwlwDJ6AgeBXAxytMOkVgNMRBoxFVFAA/F5bl9ZaZpufAwBD4EXasa810FVQJOILdDk2SVkCKg9qUXAKAAmHIg17hogDCQqWfk+XkBANRaChIQA7";
$icons["sql"] = "R0lGODlhDQAQAMQAAAAAAP///4WS2djc8wAboQAWiAcjsh85uzJJwEdcxVptzZml36225cXN7uvu+YSGhMbHxv///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAABEALAAAAAANABAAAAVV4COOZGQ+Qaqm0HOuKxS4KJwCOFDbrG47DEcA4oMZFgQHcTdIDBABA2MZYCQOgtSAMNQlpCtFo/tgHA4MVZqcalwDjUJvFxi05zzVEsLv+4k5gYIAIQA7";
$icons["txt"] = "R0lGODlhEAAQAMIAAP///wAAAMzMzJmZmWZmZv///////////yH5BAEAAAcALAAAAAAQABAAAANCeBrA3ioeNkC9MNbH8yFAKI5CoI0oUJ5N4DCqqYCpuCpV67rhfeS1WIS22/Vkv+CRVeQJZ8pnUukbCK7YrG/SbEYSADs=";
$icons["xls"] = "R0lGODlhEAAQAOMAAP///8zMzAAAAJmZmQBmAACZAGZmZmaZZplmmZnMmcyZzP///////////////////yH5BAEAAA8ALAAAAAAQABAAAARv8MlhqK1G6meA/94gSAVSDN9AoEA3HgTcwbAn3AIBrOW6BkBAYFQAFAzHUiIkHD10JWVAERw+VUakyRNoFmhQkyGQUAASAoQP6wMNv7FYMS5salg7FaprlXSAZEIDXSJ3IId2fkCDgI1ODyI4kpIRADs=";
$icons["xml"] = "R0lGODlhEAAQAMQAAAAA/wAAnAAAhDFj/zFjnKXO9zGc/zHO/wCEhDH//zGcAMDAwP////f398bGxoSEhAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAsALAAAAAAQABAAQAVl4COOpLicy8M0RcMI8NoyUCq7CDLctN0QwGDQVVMxjkhXw8F4nB6FwAqROCgErkChuBJ6ib6VWCnmIs9Hh/N5JJMhcG6UgWAkDAKGtiGXDgwKAHl7Zm5jK4WHbomGSjVxkJFxCyEAOw==";
$icons["xsl"] = "R0lGODlhEAAQAMQAAAAA/wAAnAAAhDFj/zFjnKXO9zGc/zHO/wCEhDH//8DAwDGcAP//AISEAP////f398bGxoSEhAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAoALAAAAAAQABAAQAV5oBKNZDkqqOg0zeMIsPMUrqTOLoIMMu1ILIYkwmhICEhk7SZruh4QRwQVKQRkiMRhIXAFCrYGY2xEJJU/BXAoeTyd6ch77oBMqfS3ZG+TWx0IDgkGAg5fD30zVwMGCwCFh2Fie3kyQGMREkVtcIgKYmRteTZ8paZ8IQA7";
$icons["enc"] = "iVBORw0KGgoAAAANSUhEUgAAAA0AAAAQCAIAAABCwWJuAAAABnRSTlMAAQABAABSBEQWAAAAtElEQVR4Xo2QIRLCMBBFf2wFIiKisjIioiICUYGsRCA4zZ6ggiMgOAI6mktBprtdMslM4U3M/nmT/A32MUZOC+l53F8Gux6JimV5sgr6RfS33kUweX6vpJSq13MY4hUb4lFGxQ0/XjipPBJAnITpjOJ+Ia3oSKDjOOuC0PvKzTnp/Qz5AvVaQP1w+jauPM65q3MRBGKxLKRwUWdHlNuJASoBYG1gr4ZLK/YQikkLNXTdgD/5AFR03AJZz/iFAAAAAElFTkSuQmCC";
$icons["mus"] = "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAIAAACQkWg2AAAABnRSTlMAAAAAAABupgeRAAAA50lEQVR4XpXSsQ2DMBAFUBcpqdmB+ipa+sxAdyu4SeGKEZCuo8gETMAAXoGKDqVhAufHp8QCF4EvhODw0wn7zJkQCbHcYhJwzt1jrLXD8ATouq5tW1SI2L8CTAKoLssSYvDAzJDhGwVqDNI0Tfjl4bZtAzsAvQxFgEYJEAWRA0CstVhWVVUGjAne56DvewAU90A8OkDlYJ5nABbZAyKAvIMGwCAJYB2AMTDngBoA5itAPHb2Ajj7D3pYuK/rCvgfTNMkIkVRAGtDTFFZlvo6jiPmZQfqusbRqGdmGMwLi+jG4xMWKLicN69ffiKUTt0jAAAAAElFTkSuQmCC";
$icons["mmm"] = "iVBORw0KGgoAAAANSUhEUgAAAA8AAAAQCAIAAABGNLJTAAAABnRSTlMAAQAAAABTxi4hAAAAVElEQVR4Xq2PQQ7AIAgE8ec+jZ8phuhqi2JTNhvDYRiV8jGJaG6jyybMjIUbWk4BrmjSmG4Zte8bFhpoH8Jo+yW6+aj9S8+NwBrphjXSDWug+y6DriunfE5T98OKAAAAAElFTkSuQmCC";
$icons["sib"] = "iVBORw0KGgoAAAANSUhEUgAAAA0AAAAQCAIAAABCwWJuAAAABnRSTlMAAQAAAABTxi4hAAABdElEQVR4Xo2RIY8VQRCE615ajBgxYsUjWbHyQrBc3k+4XE5cCI6E8BsAgUYDgh+BQBMU4gQhJ06ceOLEihOIFSNatCjRgp4ZAZJvK53ZVG1Pz+zJ1y+/cskpJXcHMEqrDjO+eHmGjgjy+fkTBN5CJOgQgVZs1T5++v7m9QWAHZuJELsspGOB7bfatjx9/BmAkEKHoHnuyAkp/f3m7v7bfsmP6pmgJwIHpj0GqqiKUubnr96y4OHdTzFDqI2ZMXCgGjaCAl3ghLuPfi1nxL6n1aAOzMjFS2EqSbILydHPpU0WTLmtq/hMw1GX5B+MQrr23LK0GrhjrfhxFGVWT2E9EM1hz63ruD+/OVLCXTXTQLKfX9xt7GuVxzvr/ThNgq2CJsZQRHZmrqYWUj09lcur6fJqLkVUzYzxWD/wzt21BjrPcjiU8SvVSFOaseNouf5qBoQNGm5v6/X1vYcRogdwnDy7eI8ggfScE822TcP5B2zbDf6TP0zTJLlBurQ+AAAAAElFTkSuQmCC";
$icons["mid"] = $icons["mp3"];
/***************************************************************************/
/*   HERE COMES THE CODE.                                                  */
/*   DON'T CHANGE UNLESS YOU KNOW WHAT YOU ARE DOING ;)                    */
/***************************************************************************/
if(isset($_GET['img']))
{
	if(strlen($_GET['img']) > 0)
	{
		header('Content-type: image/gif');
		if(isset($icons[$_GET['img']]))
			print base64_decode($icons[$_GET['img']]);
		else
			print base64_decode($icons["unknown"]);
	}
	die();
}
$_LANG = $_TRANSLATIONS[$lang];
function fileSizeF($size) 
{
	$sizes = Array('B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB');
	$y = $sizes[0];
	for ($i = 1; (($i < count($sizes)) && ($size >= 1024)); $i++) 
	{
		$size = $size / 1024;
		$y  = $sizes[$i];
	}
	return round($size, 2)." ".$y;
}
function fileRealSize($file)
{
	$sizeInBytes = filesize($file);
	if (!$sizeInBytes) {
		$sizeInBytes=exec("ls -l '$file' | awk '{print $5}'");
	}
	else
		return $sizeInBytes;
}
function fileExtension($file)
{
	$a = explode(".", $file);
	$b = count($a);
	return $a[$b-1];
}
function fileChanged($time)
{
	return date("d.m.y H:i:s", $time);
}
function fileIcon($l)
{
	$l = strtolower($l);
	return "?img=".$l;
}
function makeArrow($sort_by, $sort_as, $type, $dir, $text)
{
	if($sort_by == $type && $sort_as == "desc")
	{
		return "<a href=\"?dir=".$dir."&amp;sort_by=".$type."&amp;sort_as=asc\">
		$text <img style=\"border:0;\" alt=\"asc\" src=\"?img=arrow_up\" /></a>";
	}
	else
		return "<a href=\"?dir=".$dir."&amp;sort_by=".$type."&amp;sort_as=desc\">
		$text <img style=\"border:0;\" alt=\"desc\" src=\"?img=arrow_down\" /></a>";
}
function name_cmp_desc($a, $b)
{
   return strcasecmp($a["name"], $b["name"]);
}
function size_cmp_desc($a, $b)
{
	return ($a["size"] - $b["size"]);
}
function size_cmp_asc($b, $a)
{
	return ($a["size"] - $b["size"]);
}
function changed_cmp_desc($a, $b)
{
	return ($a["changed"] - $b["changed"]);
}
function changed_cmp_asc($b, $a)
{
	return ($a["changed"] - $b["changed"]);
}
function name_cmp_asc($b, $a)
{
	return strcasecmp($a["name"], $b["name"]);
}
function sum_dir($start_dir, $ignore_files, $levels = 1) 
{
	if ($dir = opendir($start_dir)) 
	{
		$filesize = 0;
		while ((($file = readdir($dir)) !== false)) 
		{
			if (!in_array($file, $ignore_files)) 
			{
				if ((is_dir($start_dir . '/' . $file)) && ($levels - 1 >= 0)) 
				{
					$levels -= 1;
					$filesize += sum_dir($start_dir . '/' . $file, $ignore_files, $levels);
				}
				elseif (is_file($start_dir . '/' . $file)) 
				{					
					$filesize += filesize($start_dir . '/' . $file) / 1024;
				}
			}
		}
		
		closedir($dir);
		return $filesize;
	}
}
function upperDir($dir)
{
	$chops = explode("/", $dir);
	$num = count($chops);
	$chops2 = array();
	for($i = 0; $i < $num - 1; $i++)
	{
		$chops2[$i] = $chops[$i];
	}
	$dir2 = implode("/", $chops2);
	return $dir2;
}
if(!isset($_GET["dir"]) || strlen($_GET["dir"]) == 0) 
{
	$dir = $starting_dir;
	$upper_dir = "";
}
else
{
	if(ereg("\.\.(.*)", $_GET["dir"]) || $_GET["dir"][0] == '/')
	{
		$dir = $starting_dir;
		$upper_dir = "";
	}
	else
	{
		$dir = $_GET["dir"];
		$upper_dir = upperDir($dir);
	}
}
$error = NULL;
if(isset($_POST['userdir']) && strlen($_POST['userdir']) > 0)
{
	if($password && $_POST['password'] == $password)
	{
		$forbidden = array(".", "/", "\\");
		for($i = 0; $i < count($forbidden); $i++)
			$_POST['userdir'] = str_replace($forbidden[$i], "", $_POST['userdir']);
		if(!mkdir($dir."/".$_POST['userdir'], 0777))
			$error = $_LANG["new_dir_failed"];
		else if(!chmod($dir."/".$_POST['userdir'], 0777))
			$error = $_LANG["chmod_dir_failed"];
	}
	else
		$error = $_LANG["wrong_password"];
}
if(isset($_FILES['userfile']['name']) && strlen($_FILES['userfile']['name']) > 0)
{
	if($password && $_POST['password'] == $password)
	{
		$name = basename($_FILES['userfile']['name']);
		if(get_magic_quotes_gpc())
			$name = stripslashes($name);
		$upload_dir = ($basedir?$basedir:dirname($_SERVER['SCRIPT_FILENAME']))."/".$dir."/";
		$upload_file = $upload_dir . $name;
		if(!is_uploaded_file($_FILES['userfile']['tmp_name']))
		{
			$error = $_LANG["failed_upload"];
		}
		else if(!@move_uploaded_file($_FILES['userfile']['tmp_name'], $upload_file))
		{
			$error = $_LANG["failed_move"];
		}
		else
			chmod($upload_file, 0777);
	}
	else
		$error = $_LANG["wrong_password"];
}
if($open_dir = @opendir($dir))
{
$dirs = array();
$files = array();
$i = 0;
while ($it = readdir($open_dir)) 
{
	if($it != "." && $it != "..") 
	{
		if(is_dir($dir."/".$it))
		{
				if(!in_array($it, $hidden_dirs))
					$dirs[] = htmlspecialchars($it);
		}
		else if(!in_array($it, $hidden_files))
		{
			$files[$i]["name"] = htmlspecialchars($it);
			$it = $dir."/".$it;
			$files[$i]["extension"] = fileExtension($it);
			$files[$i]["size"] = fileRealSize($it);
			$files[$i]["changed"] = filemtime($it);
			$i++;
		}
	}
}
closedir($open_dir);
if($files || $dirs)
{
	if(isset($_GET["sort_by"]) && isset($_GET["sort_as"]) && $_GET["sort_by"] == "name" && $_GET["sort_as"] != "asc")
	{
		@sort($dirs);
		@usort($files, "name_cmp_desc");
	}
	elseif(isset($_GET["sort_by"]) && isset($_GET["sort_as"]) && $_GET["sort_by"] == "name" && $_GET["sort_as"] == "asc")
	{
		@rsort($dirs);
		@usort($files, "name_cmp_asc");
	}
	elseif(isset($_GET["sort_by"]) && isset($_GET["sort_as"]) && $_GET["sort_by"] == "size" && $_GET["sort_as"] != "asc" && $files)
	{
		usort($files, "size_cmp_desc");
	}
	elseif(isset($_GET["sort_by"]) && isset($_GET["sort_as"]) && $_GET["sort_by"] == "size" && $_GET["sort_as"] == "asc" && $files)
	{
		usort($files, "size_cmp_asc");
	}
	elseif(isset($_GET["sort_by"]) && isset($_GET["sort_as"]) && $_GET["sort_by"] == "changed" && $_GET["sort_as"] != "asc" && $files)
	{
		usort($files, "changed_cmp_desc");
	}
	elseif(isset($_GET["sort_by"]) && isset($_GET["sort_as"]) && $_GET["sort_by"] == "changed" && $_GET["sort_as"] == "asc" && $files)
	{
		usort($files, "changed_cmp_asc");
	}
	else
	{
		@sort($dirs);
		@usort($files, "name_cmp_desc");
	}
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>
<head>
<?php css(); ?>
<meta content="text/html; charset=<?php print $charset; ?>" http-equiv="content-type" />
<title>Музыкальная Страничка ВПЗ</title>
</head>
<body>
<?php 
if($error){
?>
<div id="error"><?php print $error; ?></div>
<?php
}
?>
<div id="frame">
<?php
if($show_top){
?>
	<div id="top">
		<div class="a1">В начале было Слово, и Слово было у Бога, и Слово было Бог.</div>
		<div class="a2">Я есмь путь и истина и жизнь; никто не приходит к Отцу, как только через Меня.</div>
		<div class="a3">Ибо так возлюбил Бог мир, что отдал Сына Своего Единородного,</div>
		<div class="a4">дабы всякий верующий в Него, не погиб, но имел жизнь вечную.</div>
		<div class="a0">Славьте Господа, ибо Он благ, ибо вовек милость Его</div>
	</div>
<?php
}
?>
	<table class="table" border="0" cellpadding="3" cellspacing="0">
		<tr class="row one">
			<td class="icon">
				&nbsp;
			</td>
			<td class="name">
				<?php print makeArrow((isset($_GET["sort_by"])?$_GET["sort_by"]:""), (isset($_GET["sort_as"])?$_GET["sort_as"]:""), "name", $dir, $_LANG["file_name"]);?>
			</td>
			<td class="size">
				<?php print makeArrow((isset($_GET["sort_by"])?$_GET["sort_by"]:""), (isset($_GET["sort_as"])?$_GET["sort_as"]:""), "size", $dir, $_LANG["size"]); ?>	
			</td>
			<td class="changed">
				<?php print makeArrow((isset($_GET["sort_by"])?$_GET["sort_by"]:""), (isset($_GET["sort_as"])?$_GET["sort_as"]:""), "changed", $dir, $_LANG["last_changed"]); ?>
			</td>
		</tr>
		<tr class="row two">
			<td class="icon">
				<img alt="dir" src="?img=directory" />
			</td>
			<td colspan="3" class="long">
				<a href="?dir=<?php print $upper_dir; ?>">..</a>
			</td>
		</tr>
<?php
$row = 1;
if($dirs)
{
	foreach ($dirs as $a_dir)
	{
		$row_style = ($row ? "one" : "two");
?>
		<tr class="row <?php echo $row_style; ?>">
			<td class="icon">
				<img alt="dir" src="?img=directory" />
			</td>
			<td colspan="3" class="long">
				<?php echo "<a href=\"?dir=".$dir."/".$a_dir."\">".$a_dir."</a>"; ?>
			</td>
		</tr>
<?php
		$row =! $row;
	}
}
if($files)
{
	foreach ($files as $a_file)
	{
		$row_style = ($row ? "one" : "two");
?>
		<tr class="row <?php echo $row_style; ?>">
			<td class="icon">
				<img alt="<?php print $a_file["extension"]; ?>" src="<?php print fileIcon($a_file["extension"]); ?>" />
			</td>
			<td class="name">
<?php
			print "			<a href=\"".$dir."/".$a_file["name"]."\"";
		if($open_in_new_window)
			print "target=\"_blank\"";
		print ">".$a_file["name"]."</a>"; 
?>
			</td>
			<td class="size">
				<?php print fileSizeF($a_file["size"]); ?>
			</td>
			<td class="changed">
				<?php print fileChanged($a_file["changed"]);?>	
			</td>
		</tr>
<?php
	$row =! $row;
	}
}
?>
	</table>
<?php
if(strlen($password) > 0)
{
?>
<?php
}
?>
	<div id="info">
		<a style="float: left" href="javascript:history.back(-1);">назад</a>
		<a style="float: right" href="http://noty.bratstvo.org" target="_blank">главная</a>
	</div>
</div>
</body>
</html>
<?php
}
?>